#include "SSH.h"

namespace Upp {

Exec& Exec::StartExecute(const String& cmd, Stream& out, Stream& err)
{
	StartExec(cmd);
	StartRead(out, chunk_size);
	StartReadStdErr(err);
	StartGetExitCode();
	StartGetExitSignal();
	StartStop();
	return *this;
}

int Exec::Execute(const String& cmd, Stream& out, Stream& err)
{
	Clear();
	StartExecute(cmd, out, err);
	return JobQueue::Execute() ? code : GetError();
}
}